//--------------------------------------------------------------
//  グラフィックイコライザのクラス（ヘッダ）
//      フィルらの係数を設定しない場合は，出力は出ない
//
//  2022/02/19, Copyright (c) 2022 MIKAMI, Naoki
//--------------------------------------------------------------

#include "Array.hpp"
#include "BiquadGrEq.hpp"

#ifndef GRAPHIC_EQALIZER_HPP
#define GRAPHIC_EQALIZER_HPP

namespace Mikami
{
    class GrEqualizer
    {
    public:
        // コンストラクタ
        GrEqualizer(int bands, float fs, float qVal = 1.0f/sqrtf(2.0f));
        // グラフィック･イコライザの実行
        float Execute(float xn) { return (this->*fPtr_)((this->*fPtr2_)(xn)); }
        
        // 指定したチャンネルの係数を設定する
        void SetCoefficients(int band, BiquadGrEq::Coefs coefs)
        { biquad_[band].SetCoefficients(coefs); }

        // グラフィック･イコライザの処理を有効にする
        void Validate() { fPtr_ = &GrEqualizer::Filtering; }
        // グラフィック･イコライザの処理を無効にする
        void Invalidate() { fPtr_ = &GrEqualizer::Through; }
        // 出力を On にする    
        void SetOn() { fPtr2_ = &GrEqualizer::On; }
        // 出力を Off にする
        void SetOff() { fPtr2_ = &GrEqualizer::Off; }

    private:
        const int BANDS_;       // バンドの数
        const float Q_VAL_;     // Q 値

        Array<BiquadGrEq> biquad_;
        Array<float> f0_;

        float (GrEqualizer::*fPtr_)(float);     // イコライザ処理の有無
        float (GrEqualizer::*fPtr2_)(float);    // 出力の On/Off
        
        float Through(float xn) { return xn; }  // そのまま出力
        float Filtering(float xn);              // フィルタを実行して出力
        float On(float xn) { return xn; }       // 出力: On
        float Off(float xn) { return 0; }       // 出力: Off

        // コピー･コンストラクタ，代入演算子禁止禁止のため
        GrEqualizer(const GrEqualizer&);
        GrEqualizer& operator=(const GrEqualizer&);
    };
}
#endif  // GRAPHIC_EQALIZER_HPP
