//--------------------------------------------------------------
//  グラフィックイコライザで使う 1D タイプの 2 次のフィルタ
//      このクラスでは，係数は実行中に書き換えられることを想定している
//
//      v[n] = x[n] + a1*v[n-1] + a2*v[n-2]
//      y[n] = b0*v[n] + b1*v[n-1] + b2*v[n-2]
//          x[n] :  入力信号
//          y[n] :  出力信号
//
//  2022/02/18, Copyright (c) 2022 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#ifndef IIR_BIQUAD_GREQ_HPP
#define IIR_BIQUAD_GREQ_HPP

// 2 次の IIR フィルタ
namespace Mikami
{
    class BiquadGrEq
    {
    public:
        struct Coefs { float a1, a2, b0, b1, b2; };

        BiquadGrEq(const Coefs ck = (Coefs){0, 0, 0, 0, 0})
            : c_(ck), vn1_(0), vn2_(0) {}
        
        void SetCoefficients(const Coefs ck) { c_ = ck; }

        float Execute(float xn)
        {
            float vn = xn + c_.a1*vn1_ + c_.a2*vn2_;
            float yn = c_.b0*vn + c_.b1*vn1_ + c_.b2*vn2_;
        
            vn2_ = vn1_;
            vn1_ = vn;

            return yn;
        }

    private:
        Coefs c_;
        float vn1_, vn2_;

        // コピー･コンストラクタ禁止
        BiquadGrEq(const BiquadGrEq&);
    };
}
#endif  // IIR_BIQUAD_GREQ_HPP
