//--------------------------------------------------------------
//  グラフィックイコライザのクラス
//      フィルらの係数を設定しない場合は，出力は出ない
//
//  2022/02/19, Copyright (c) 2022 MIKAMI, Naoki
//--------------------------------------------------------------

#include "GraphicEqualizer.hpp"

namespace Mikami
{
    // コンストラクタ
    GrEqualizer::GrEqualizer(int bands, float fs, float qVal)
        : BANDS_(bands), Q_VAL_(qVal),
          biquad_(bands), f0_(bands)
    {
        for (int n=0; n<BANDS_; n++) f0_[n] = 62.5f*powf(2, n);
        SetOff();
        Validate();
    }

    // グラフィック･イコライザの実行
    float GrEqualizer::Filtering(float xn)
    {
        float yn = xn;
        for (int n=0; n<BANDS_; n++)
            yn = biquad_[n].Execute(yn);
        return yn;
    }
}
