//----------------------------------------------------------------------
//  AD 変換の結果をそのまま DA 変換する，DA 出力はアップサンプリング使用
//
//  2021/12/13, Copyright (c) 2021 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "MultirateLiPh.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため
using namespace Mikami;

const float FS_ = 10.0f;        // 入力の標本化周波数： 10 kHz
MultirateLiPh myAdDa_(FS_);     // 出力標本化周波数を４倍にするオブジェクト

// ADC 変換終了割込みに対する割込みサービス･ルーチン
void AdcIsr()
{
    float xn = myAdDa_.Input(); // 入力
    myAdDa_.Output(xn);         // 出力
}

int main()
{
    printf("\r\nAD 変換の結果をそのまま DA 変換します\r\n");
    printf("DA 変換の際はアップサンプリングを行います\r\n");

    myAdDa_.Start(&AdcIsr);     // 標本化を開始する
    while (true) {}
}