//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス（ヘッダ）
//      A2  (PA_4)： 左
//      D13 (PA_5)： 右
//
//  2020/09/22, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "mbed.h"
#include "PeripheralPins.h" // pin_function() で使用
// PeripheralPins.c が含まれるディレクトリ：
//      mbed-dev\targets\TARGET_STM\TARGET_STM32F4\
//      TARGET_STM32F446xE\TARGET_NUCLEO_F446RE

#ifndef STM32F446xx
#error Select NUCLEO-F446RE.
#endif

#ifndef F446_DAC_DUAL_HPP
#define F446_DAC_DUAL_HPP

namespace Mikami
{
    class DspDacDual
    {
    public:
        // コンストラクタ
        DspDacDual();

        virtual ~DspDacDual() {}

        // -1.0f <= data1, data2 <= 1.0f
       void Write(float data1, float data2)
        {   WriteDac(ToUint16(data1), ToUint16(data2)); }

        // 0 <= data1, data2 <= 4095
        void Write(uint16_t data1, uint16_t data2)
        {   WriteDac(__USAT(data1, BIT_WIDTH_),
                     __USAT(data2, BIT_WIDTH_)); }

    private:
        static const int BIT_WIDTH_ = 12;
        DAC_TypeDef* const DAC_;    // DA 変換器に対応する構造体のポインタ

        // float 型のデータを uint16_t 型に変換，飽和処理付き
        uint16_t ToUint16(float val)
        {   return __USAT((val + 1.0f)*2047.0f, BIT_WIDTH_); }

        // 2チャンネル分を同時に DAC に書き込む
        void WriteDac(uint16_t val1, uint16_t val2)
        {   DAC->DHR12RD = __PKHBT(val1, val2, 16); }

        // コピー･コンストラクタ，代入演算子の禁止のため
        DspDacDual(const DspDacDual&);
        DspDacDual& operator=(const DspDacDual&);     
    };
}
#endif  // F446_DAC_DUAL_HPP