//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//      A2  (PA_4)： 左
//      D13 (PA_5)： 右
//
//  2020/09/22, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "DSP_DacDual.hpp"

namespace Mikami
{
    // コンストラクタ
    DspDacDual::DspDacDual() : DAC_(DAC1)
    {
        // DAC で使うピンに対応する GPIOx_MODER をアナログ･モードに設定する
        pin_function(PA_4, STM_MODE_ANALOG);
        pin_function(PA_5, STM_MODE_ANALOG);

        __HAL_RCC_DAC_CLK_ENABLE(); // DAC にクロックを供給する
        // __HAL_RCC_DAC_CLK_ENABLE() の定義：stm32f4xx_hal_rcc_ex.h

        DAC_->CR = DAC_CR_EN1 | DAC_CR_EN2;
    }
}