//-------------------------------------------------------------
//  STM32F446 内蔵 ADC をポーリング方式で使うための派生クラス
//      基底クラス： DspAdcDualBase
//
//  2020/09/22, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "DSP_AdcDualBase.hpp"

#ifndef DSP_ADC_DUAL_POLLING_HPP
#define DSP_ADC_DUAL_POLLING_HPP

namespace Mikami
{
    class DspAdcDualPolling : public DspAdcDualBase
    {
    public:
        // コンストラクタ
        //      fSampling   標本化周波数 [kHz]
        //      pinCh1      チャンネル 1 に対応する入力ピンの名前
        //      pinCh2      チャンネル 2 に対応する入力ピンの名前
        DspAdcDualPolling(float fSampling, PinName pinCh1, PinName pinCh2)
            : DspAdcDualBase(fSampling, pinCh1, pinCh2) {}

        virtual ~DspAdcDualPolling() {}

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual void Read(float &ad1, float &ad2) const
        {
            while((ADC->CSR & EOC23_) != EOC23_) {} // AD 変換が完了するまで待つ
            ad1 = ToFloat(adcCh1_->DR);
            ad2 = ToFloat(adcCh2_->DR);
        }

private:
        static const uint32_t EOC23_ = ADC_CSR_EOC2 | ADC_CSR_EOC3;

        // コピー･コンストラクタ，代入演算子の禁止のため
        DspAdcDualPolling(const DspAdcDualPolling&);
        DspAdcDualPolling& operator=(const DspAdcDualPolling&);
    };
}
#endif  // DSP_ADC_DUAL_POLLING_HPP