//-------------------------------------------------------------
//  STM32F446 内蔵 ADC を割り込み方式で使うための派生クラス
//      基底クラス： DspAdcDualBase
//
//  2021/06/29, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------------

#include "DSP_AdcDualBase.hpp"

#ifndef DSP_ADC_DUAL_INTERRUPT_HPP
#define DSP_ADC_DUAL_INTERRUPT_HPP

namespace Mikami
{
    class DspAdcDualIntr : public DspAdcDualBase
    {
    public:
        // コンストラクタ
        //      fSampling   標本化周波数 [kHz]
        //      pinCh1      チャンネル 1 に対応する入力ピンの名前
        //      pinCh2      チャンネル 2 に対応する入力ピンの名前
        DspAdcDualIntr(float fSampling, PinName pinCh1, PinName pinCh2)
            : DspAdcDualBase(fSampling, pinCh1, pinCh2)
        {   adcCh1_->CR1 |= ADC_CR1_EOCIE; }

        virtual ~DspAdcDualIntr() {}

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual void Read(float &ad1, float &ad2) const
        {
            ad1 = ToFloat(adcCh1_->DR);
            ad2 = ToFloat(adcCh2_->DR);
        }

        // 割り込みベクタの設定と ADC 割り込みの有効化
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
            NVIC_EnableIRQ(ADC_IRQn);                   // See "core_cm4.h"
        }

        // ADC 割込みを有効にする
        void EnableIntr() { NVIC_EnableIRQ(ADC_IRQn); }

        // ADC 割込みを無効にする
        void DisableIntr() { NVIC_DisableIRQ(ADC_IRQn); }

private:
        // コピー･コンストラクタ，代入演算子の禁止のため
        DspAdcDualIntr(const DspAdcDualIntr&);
        DspAdcDualIntr& operator=(const DspAdcDualIntr&);
    };
}
#endif  // DSP_ADC_DUAL_INTERRUPT_HPP