//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//
//  2020/05/21, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "DSP_Dac.hpp"

namespace Mikami
{
    // コンストラクタ
    DspDac::DspDac(PinName pin) : DAC_(DAC)
    {
        // このクラスのオブジェクトの複数生成禁止のため
        MBED_ASSERT(!created_);
        created_ = true;

        // pin に対応する DAC が存在するか確認
        MBED_ASSERT( (pin == A2) || (pin == D13) );

        // pin に対応する GPIOx_MODER をアナログ･モードに設定する
        pin_function(pin, STM_MODE_ANALOG);

        __HAL_RCC_DAC_CLK_ENABLE(); // DAC にクロックを供給する
        // __HAL_RCC_DAC_CLK_ENABLE() の定義：stm32f4xx_hal_rcc_ex.h

        if (pin == A2)
        {
            DAC_->CR = DAC_CR_EN1;
            fpWrite_ = &DspDac::WriteDac1;
        }
        else
        {
            DAC_->CR = DAC_CR_EN2;
            fpWrite_ = &DspDac::WriteDac2;
        }
    }
    bool DspDac::created_ = false;
}