//-------------------------------------------------------------
//  STM32F446 内蔵 ADC をポーリング方式で使うための派生クラス
//      基底クラス： DspAdc_Base
//
//  2020/05/21, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "DSP_AdcBase.hpp"

#ifndef DSP_ADC_POLLING_HPP
#define DSP_ADC_POLLING_HPP

namespace Mikami
{
    class DspAdcPolling : public DspAdcBase
    {
    public:
        // コンストラクタ
        //      fSampling   標本化周波数 [kHz]
        //      pin         入力ピンの名前
        //      adc         AD 変換器: ADC1, ADC2, ADC3 のいずれか
        DspAdcPolling(float fSampling, PinName pin,
                       ADC_TypeDef* const adc = ADC2)
            : DspAdcBase(fSampling, pin, adc) {}

        virtual ~DspAdcPolling() {}

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() const
        {
            while ((myAdc_->SR & ADC_SR_EOC_Msk) != ADC_SR_EOC) {}
            return AdcToFloat();
        }
    };
}
#endif  // DSP_ADC_POLLING_HPP