//-----------------------------------------------------------------
//  STM32F446 内蔵 ADC を割込み方式で使うための派生クラス（ヘッダ）
//      基底クラス： DspAdc_Base
//
//  2020/12/20, Copyright (c) 2020 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "DSP_AdcBase.hpp"

#ifndef DSP_ADC_INTERRUPT_HPP
#define DSP_ADC_INTERRUPT_HPP

namespace Mikami
{
    class DspAdcIntr : public DspAdcBase
    {
    public:
        // コンストラクタ
        //      fSampling   標本化周波数 [kHz]
        //      pin         入力ピンの名前
        //      adc         AD 変換器: ADC1, ADC2, ADC3 のいずれか
        DspAdcIntr(float fSampling, PinName pin, ADC_TypeDef* const adc = ADC2)
            : DspAdcBase(fSampling, pin, adc)
        {   myAdc_->CR1 |= ADC_CR1_EOCIE; }     // AD 変換終了割込みを許可

        virtual ~DspAdcIntr() {}

        // 割込みベクタの設定と AD 変換割込みを有効にする
        void SetIntrVec(void (*Func)());

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() const { return AdcToFloat(); }

    private:
        static void (*fp_)();   // 割込みサービス･ルーチンの中で実行される関数のポインタ

        // 割込みサービス･ルーチン，このクラスで使っている ADC の割込みであれば，
        // NVIC_SetVector() の引数で割り当てられた処理を行う
        static void Isr()
        {   if ((myAdc_->SR & ADC_SR_EOC_Msk) == ADC_SR_EOC) fp_(); }
    };
}
#endif  // DSP_ADC_INTERRUPT_HPP