//-------------------------------------------------------------
//  STM32F446 内蔵 ADC を割込み方式で使うための派生クラス
//      基底クラス： DspAdc_Base
//
//  2020/12/20, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "DSP_AdcIntr.hpp"

namespace Mikami
{
    // 割込みベクタの設定と AD 変換割込みを有効にする
    void DspAdcIntr::SetIntrVec(void (*Func)())
    {
        fp_ = Func;         // 引数として渡された処理を割り当てる
        NVIC_SetVector(ADC_IRQn, (uint32_t)Isr);    // "core_cm4.h" 参照
        NVIC_EnableIRQ(ADC_IRQn);                   // "core_cm4.h" 参照
    }    

    // static メンバの実体
    void (*DspAdcIntr::fp_)();
}