//-------------------------------------------------------
//  FFT を使ってスペクトル解析を行うクラス（ヘッダ）
//
//  2019/11/22, Copyright (c) 2019 MIKAMI, Naoki
//-------------------------------------------------------

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "Array.hpp"
#include "fftReal.hpp"
#include "Hamming.hpp"

namespace Mikami
{
    class FftAnalyzer
    {
    public:
        // nFft:  FFT のデータ点の数
        FftAnalyzer(int nFft);
        virtual ~FftAnalyzer() {}
        void Execute(const Array<float> &xn, Array<float> &db);

    private:
        const int N_FFT_;

        FftReal fft_;
        HammingWindow wHm_;

        Array<float> xData_;    // 解析対象の時系列データ
        Array<float> wData_;    // 窓掛けされたデータ
        Array<Complex> yFft_;   // FFT の結果

        // 絶対値の２乗
        float Norm(Complex x)
        { return x.real()*x.real() + x.imag()*x.imag(); }

        // コピー･コンストラクタおよび代入演算子の禁止のため
        FftAnalyzer(const FftAnalyzer& );
        FftAnalyzer& operator=(const FftAnalyzer& );
    };
}
#endif  // FFT_ANALYZER_HPP

