//-------------------------------------------------------
//  FFT を使ってスペクトル解析を行うクラス
//
//  2019/11/22, Copyright (c) 2019 MIKAMI, Naoki
//-------------------------------------------------------

#include "FFT_Analyzer.hpp"

namespace Mikami
{
    FftAnalyzer::FftAnalyzer(int nFft)
        : N_FFT_(nFft), fft_(nFft), wHm_(nFft, nFft),
          xData_(nFft), wData_(nFft), yFft_(nFft/2+1) {}

    void FftAnalyzer::Execute(const Array<float> &xn, Array<float> &db)
    {
        xData_ = xn;    // データを作業領域にコピー

        // 直流分を除去
        float sum = 0;
        for (int n=0; n<N_FFT_; n++) sum = sum + xData_[n];
        float ave = sum/N_FFT_;
        for (int n=0; n<N_FFT_; n++) xData_[n] = xData_[n] - ave;

        wHm_.Execute(xData_, wData_);   // 窓掛け
            
        fft_.Execute(wData_, yFft_);    // FFT の実行
        
        for (int n=0; n<=N_FFT_/2; n++) // dB 値に変換
        {
            float norm = Norm(yFft_[n]);
            db[n] = (norm > 0) ? 10.0f*log10f(norm) : -40.0f;
        }
    }
}

