//---------------------------------------------------
//  縦続形 IIR フィルタ
//
// 2019/11/12, Copyright (c) 2019 MIKAMI, Naoki
//---------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "Biquad.hpp"
#include "Array.hpp"    // Array クラスが定義されている
using namespace Mikami;

class IirCascade
{
public:
    // コンストラクタ
    IirCascade(int order, const Biquad hk[], float g0)
        : ORDER2_((order+1)/2), G0_(g0), hn_((order+1)/2, hk) {}

    // フィルタ処理を実行する
    float Execute(float xn)
    {
        float yn = G0_*xn;
        for (int k=0; k<ORDER2_; k++) yn = hn_[k].Execute(yn);
        return yn;
    }

private:
    const int ORDER2_;  // 次数/2，ただし次数が奇数の場合は(次数+1)/2
    const float G0_;    // 利得定数
    Array<Biquad> hn_;  // Biquad クラスのオブジェクトの配列

    // コピー･コンストラクタおよび代入演算子の禁止のため
    IirCascade(const IirCascade& );
    IirCascade& operator=(const IirCascade& );
};
#endif  // IIR_CASCADE_HPP

