//--------------------------------------------------------------
// 縦続形 IIR フィルタの構成要素として使う 2 次の IIR フィルタ
//      b0 は 1 と仮定している
//
//      u[n] = x[n] + a1*u[n-1] + a2*u[n-2]
//      y[n] = u[n] + b1*u[n-1] + b2*u[n-2]
//
// 2019/11/22, Copyright (c) 2019 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_HPP
#define IIR_BIQUAD_HPP

#include "mbed.h"

// 2 次の IIR フィルタ
class Biquad
{
public:
    // デフォルト･コンストラクタ
    Biquad() {}

    // 係数を個別に与えるコンストラクタ
    Biquad(float a1, float a2, float b1, float b2)
        : a1_(a1), a2_(a2), b1_(b1), b2_(b2), un1_(0), un2_(0) {}       

    // 2 次のフィルタを実行する
    float Execute(float xn)
    {
        float un = xn + a1_*un1_ + a2_*un2_;
        float yn = un + b1_*un1_ + b2_*un2_;
        
        un2_ = un1_;
        un1_ = un;
        
        return yn;
    }

private:
    float a1_, a2_, b1_, b2_;
    float un1_, un2_;

    // コピー･コンストラクタ禁止
    Biquad(const Biquad&);
};

#endif  // IIR_BIQUAD_HPP


