//-------------------------------------------------------------
//  F446 内蔵 ADC2 のための抽象基底クラス(ヘッダ)
//
//  2020/01/28 Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------

#include "mbed.h"

#ifndef ADC_F446_BASE_HPP
#define ADC_F446_BASE_HPP

namespace Mikami
{
    class AdcF446_Base
    {
    public:
        // コンストラクタ
        //      fSampling 標本化周波数 [kHz]
        //      pin     入力ピンの名前
        AdcF446_Base(float fSampling, PinName pin);

        virtual ~AdcF446_Base() {}

        // AD 変換された値を読み込む
        //      -1.0f <= AD変換された値 < 1.0f
        virtual float Read() const = 0; // 純粋仮想関数

    protected:
        static ADC_TypeDef* const myAdc_;   // AD 変換器に対応するポインタ
        float ToFloat(uint16_t x) const { return AMP_*(x - 2048); }
    
    private:
        static const float AMP_ = 1.0f/2048.0f;
        // AD 変換器の外部トリガに使うタイマ (TIM8) の設定
        //      fSampling 標本化周波数 [kHz]
        void SetTim8(float fSampling);
        
        // AD 変換器に関係のある GPIO の設定
        void SetGPIO(PinName pin);

        // コピー･コンストラクタ，代入演算子の禁止のため
        AdcF446_Base(const AdcF446_Base&);
        AdcF446_Base& operator=(const AdcF446_Base&);
    };
}
#endif  // ADC_F446_BASE_HPP
