//-----------------------------------------------------
//  縦続形 IIR フィルタの次数と係数の定義
//
//  2019/11/14, Copyright (c) 2019 MIKAMI, Naoki
//-----------------------------------------------------

#include "Biquad.hpp"

// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 8 次
// 標本化周波数：160.00 kHz
// 遮断周波数　：  8.00 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER_ = 8;
const Biquad CK_[] = {
    Biquad(1.809727E+00f, -8.261113E-01f, -8.082254E-01f, 1.0E+00f),    // 1段目
    Biquad(1.842528E+00f, -8.959587E-01f, -1.755464E+00f, 1.0E+00f),    // 2段目
    Biquad(1.871837E+00f, -9.562537E-01f, -1.853590E+00f, 1.0E+00f),    // 3段目
    Biquad(1.890836E+00f, -9.887843E-01f, -1.875058E+00f, 1.0E+00f)};   // 4段目
const float G0_ = 1.281836E-03f;    // 利得定数

