//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス
//      出力端子：   A2  (PA_4)
//
//  2020/01/28, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------
#include "mbed.h"

#ifndef DAC_F446_SINGLE_HPP
#define DAC_F446_SINGLE_HPP

namespace Mikami
{
    class DacF446
    {
    public:
        // コンストラクタ， A2 に接続される CH1 のみを有効にする
        DacF446() : da_(A2) { DAC->CR = DAC_CR_EN1; }

        virtual ~DacF446() {}

        // -1.0f <= data <= 1.0f
        void Write(float data) { WriteDacCh1(ToUint16(data)); }

        // 0 <= data <= 4095
        void Write(uint16_t data) { WriteDacCh1(__USAT(data, BIT_WIDTH_)); }

    private:
        static const int BIT_WIDTH_ = 12;
        AnalogOut da_;

        // DAC の CH1 へ右詰めで出力する
        void WriteDacCh1(uint16_t val) { DAC->DHR12R1 = val; }

        // 飽和処理を行い uint16_t 型のデータを戻り値とする
        uint16_t ToUint16(float val)
        {   return __USAT((val + 1.0f)*2048.0f, BIT_WIDTH_); }

        // コピー･コンストラクタ禁止のため
        DacF446(const DacF446&);
        // 代入演算子禁止のため
        DacF446& operator=(const DacF446&);
    };
}
#endif  // DAC_F446_SINGLE_HPP
