//------------------------------------------------------------
//  mbed に登録しているライブラリ F746_GUI の使い方の簡単な例
//  CQ出版社インターフェースオフ会 2018/03/16 で紹介
//          mbed のリボジョン：161
//          ライブラリ F746_GUI のリビジョンが 32 の場合，中に含まれる
//          BSP_DISCO_F746NG はリビジョン 9 に更新すること
//
// 2018/03/12, Copyright (c) 2018 MIKAMI, Naoki
//------------------------------------------------------------

#include "F746_GUI.hpp"     // GUI 用のライブラリのインクルード文をまとめたもの

// SeekBar と ResetButton を使う例
void Slider()
{
    GuiBase::Clear();       // 画面のクリア

    // リセットボタンのオブジェクト生成
    ResetButton myReset;
    // SeekBar の値を表示する NumericLabel のオブジェクト生成
    NumericLabel<int> myLabel(240, 140, "%d", 0, Label::CENTER);
    // SeekBar のオブジェクト生成
    SeekBar myBar(140, 200, 200, -100, 100, 0, "-100", "0", "100");

    while (true)
    {
        if (myBar.Slide())      // スライドしたかどうかのチェック
            myLabel.Draw(myBar.GetValue()); // スライドすると対応する数値が表示される
        myReset.DoIfTouched();  // タッチするとリセットされる
    }
}

int main()
{
    // Label のオブジェクト生成
    Label label1(240, 10, "Simple GUI Demo", Label::CENTER, Font20);
    // ButtonGroup のオブジェクト生成
    const string STR[] = {"A", "B", "C", "D"};
    ButtonGroup bGroup1(200, 70, 80, 40, 4,
                        STR, 0, 2);

    int buttonNum;
    while (true)
    {
        // bGroup1 をタッチした場合に switch 文を実行する
        if (bGroup1.GetTouchedNumber(buttonNum))
            switch (buttonNum)
            {
                case 0: Slider(); break;
                case 1: /* 処理１ */ break;
                case 2: /* 処理２ */ break;
                case 3: /* 処理３ */ break;
            }
    }
}
