//----------------------------------------------------------------------
//  二相発振器（多項式近似を使う方法，加法定理を使う方法，IIR フィルタを使う方法）
//
//  2017/03/02, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------------------
#include "mbed.h"

//#define USING_POLYNORMIAL   // 多項式近似を使う場合このコメントを有効にする
#define USING_ADD_THEOREM   // 加法定理を使う場合このコメントを有効にする
//#define USING_2ND_ORDER_IIR // IIR フィルタを使う場合このコメントを有効にする
const int TS_ = 10;     // 標本化間隔：10 μs
const int F0_ = 5000;   // 8 kHz

#ifdef USING_POLYNORMIAL
#include "QuadOscPoly.hpp"
QuadOscPoly osc_(F0_, TS_);         // 460 ns
#endif  // USING_POLYNORMIAL

#ifdef USING_ADD_THEOREM
#include "QuadOscAddFixed.hpp"
QuadOscAddTheorem osc_(F0_, TS_);   // 300 ns
#endif  // USING_ADDITION_THEOREM

#ifdef USING_2ND_ORDER_IIR
#include "QuadOscIirFixed.hpp"
QuadOscIIR osc_(F0_, TS_);          // 250 ns
#endif  // USING_2ND_ORDER_IIR

Ticker timer_;
AnalogOut da1_(A2);
AnalogOut da2_(D13);
DigitalOut dOut_(D2);

void TimerIsr()
{
    int16_t sn1, sn2;
    dOut_ = 1;
    osc_.Generate(sn1, sn2);
    dOut_ = 0;
    da1_.write_u16(sn1+32768);
    da2_.write_u16(sn2+32768);
}

int main()
{
    timer_.attach_us(&TimerIsr, TS_);
    
    while (true) {}
}
