//--------------------------------------------------------------
//  ミニマックス近似式で sin 関数，cos 関数の値を求める
//      (π/2)x に対する sin, cos を求める
//      小数点以下のビット数： 14 ビット
//      実際の数値と，引数および戻り値の対応関係
//              0 → 0
//          16384 → 1
//  2017/03/04, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"
#include "FixedFloat.hpp"

#ifndef SIN_FIXED_INT16T_HPP
#define SIN_FIXED_INT16T_HPP

const int32_t SIN_A1_ = ToFixed29( 0.57079101); // a1 - 1
const int32_t SIN_A3_ = ToFixed29(-0.64589285); // a3
const int32_t SIN_A5_ = ToFixed29( 0.07943434); // a5
const int16_t SIN_A7_ = ToFixed15(-0.00433310); // a7

inline int16_t Sin16(int16_t x)
{
    if (abs(x) > 0x4000) x = 0x8000 - x;    // x ← 2 - x

    int16_t x2  = Round14(x*x);
    int32_t acc = Round14(Round14(Round14
                  (SIN_A7_*x2 + SIN_A5_)*x2
                              + SIN_A3_)*x2
                              + SIN_A1_)*x;
    return Round15(acc) + x;
}

inline int16_t Cos16(int16_t x) { return Sin16(16384 - x); }

#endif  // SIN_FIXED_INT16T_HPP