//--------------------------------------------------------------
//  ミニマックス近似式で求める sin 関数を利用する二相発振器のクラス
//
//  2017/02/26, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "SinCosFixed.hpp"

#ifndef QUAD_PHASE_OSC_POLY_FIXED_HPP
#define QUAD_PHASE_OSC_POLY_FIXED_HPP

class QuadOscPoly
{
public:
    // Constructor
    QuadOscPoly(float f0, float ts)
        : C0_(ToFixed14(4.0f*f0*ts*1.0E-6f)), phi_(0) {} 

    void Generate(int16_t &sinX, int16_t &cosX)
    {
        sinX = Sin16(phi_);
        cosX = Cos16(phi_);
        phi_ = phi_ + C0_;
    }
private:
    const int16_t C0_;
    int16_t phi_;
};
#endif  // QUAD_PHASE_OSC_POLY_FIXED_HPP
