//--------------------------------------------------------------
//  IIR フィルタを利用する二相発振器のクラス
//
//  2017/03/02, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"
#include "FixedFloat.hpp"

#ifndef QUAD_PHASE_OSC_IIR_FIXED_HPP
#define QUAD_PHASE_OSC_IIR_FIXED_HPP

class QuadOscIIR
{
public:
    // Constructor
    QuadOscIIR(float f0, float ts)
        : A1_(ToFixed14(2.0f*cosf(6.283185f*f0*ts*1.0E-6f))),
          B1S_(ToFixed14(sinf(6.283185f*f0*ts*1.0E-6f))),
          B1C_(ToFixed14(-cosf(6.283185f*f0*ts*1.0E-6f))),
          un1_(ToFixed14(1.0f)), un2_(0) {}
    
    void Generate(int16_t &sinX, int16_t &cosX)
    {
        // u[n] = a1*u[n-1] - u[n-2]
        int32_t un = Round14(A1_*un1_) - un2_;

        sinX = Round14(B1S_*un1_);
        cosX = un + Round14(B1C_*un1_);

        un2_ = un1_;    // u[n-2] ← u[n-1]
        un1_ = un;      // u[n-1] ← u[n]
    }
private:
    const int16_t A1_, B1S_, B1C_;
    int32_t un1_, un2_;
};
#endif  // QUAD_PHASE_OSC_IIR_FIXED_HPP
