//--------------------------------------------------------------
//  三角関数の加法定理を使う二相発振器のクラス
//
//  2017/03/02, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"
#include "FixedFloat.hpp"

#ifndef QUAD_PHASE_OSC_ADDTHEOREM_FIXED_HPP
#define QUAD_PHASE_OSC_ADDTHEOREM_FIXED_HPP

class QuadOscAddTheorem
{
public:
    // Constructor
    QuadOscAddTheorem(float f0, float ts)
        : A1_(ToFixed14(cosf(6.283185f*f0*ts*1.0E-6f))),
          B1_(ToFixed14(sinf(6.283185f*f0*ts*1.0E-6f))),
          xn1_(ToFixed14(1.0f)), yn1_(0) {}

    void Generate(int16_t &yn, int16_t &xn)
    {
        yn = Round14( A1_*yn1_ + B1_*xn1_); // sin
        xn = Round14(-B1_*yn1_ + A1_*xn1_); // cos

        // 振幅の補正
        int16_t c1 = Q14_1p5 -
                     ((Round14(xn*xn + yn*yn) + 1) >> 1);
        xn = Round14(c1*xn);
        yn = Round14(c1*yn);

        xn1_ = xn;
        yn1_ = yn;
    }

private:
    const int16_t A1_, B1_;
    static const int16_t Q14_1p5 = 0x6000;  // 1.5Q14
    int16_t xn1_, yn1_;
};
#endif  // QUAD_PHASE_OSC_ADDTHEOREM_FIXED_HPP
