//-------------------------------------------------------------------
//  固定小数点数の演算を扱う際に使うインライン関数
//
//  2017/03/03, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------------------
#include "mbed.h"

#ifndef QN_INLINE_FUNCTIONS_HPP
#define QN_INLINE_FUNCTIONS_HPP

// 丸めのために使う
inline float ForRound(float x)
{   return (x > 0) ? 0.5f : -0.5f; }

// float 型の引数を int16_t 型の Q14 に変換する
inline int16_t ToFixed14(float x)
{   return (int16_t)(x*16384.0f + ForRound(x)); }

// float 型の引数を int16_t 型の Q15 に変換する
inline int16_t ToFixed15(float x)
{   return (int16_t)(x*32768.0f + ForRound(x)); }

// float 型の引数を int16_t 型の Q29 に変換する
inline int32_t ToFixed29(float x)
{   return (int32_t)(x*32768.0f*16384.0f); }

// 下位ビットを丸めて右に 14 ビットシフトする
inline int32_t Round14(int32_t x)
{   return (x + 0x2000) >> 14; }

// 下位ビットを丸めて右に 154 ビットシフトする
inline int32_t Round15(int32_t x)
{   return (x + 0x4000) >> 15; }

#endif  // QN_INLINE_FUNCTIONS_HPP
