//-----------------------------------------------------------
//  時間軸の Zoom ボタン
//
//  2017/08/09, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef ZOOM_BUTTON_HPP
#define ZOOM_BUTTON_HPP

#include "F746_GUI.hpp"
#include "DelayedEnabler.hpp"

namespace Mikami
{
    class ZoomButton
    {
    public:
        // delay: ZoomButton がタッチされた後に再び有効になるまでの時間（単位：秒）
        ZoomButton(uint16_t x0, uint16_t y0, uint16_t w0, uint16_t h0,
                   uint32_t max, uint32_t min = 1, float delay = 0.2f)
            : X0_(x0), Y0_(y0), W0_(w0), H0_(h0), 
              MAX_(max), MIN_(min), delay_(delay), factor_(1)
        {
            zoom_ = new ButtonGroup(x0, y0, w0, h0, 2, (string[]){"-", "+"},
                                    5, 0, 2);
            zoom_->Inactivate(0);   // ズームアウトボタンは無効にする
        }

        // タッチした場合は factor を *2 または /2 する
        bool Touched(int &factor)
        {
            if (!delay_.IsEnabled()) return false;
            int num;
            if (!zoom_->GetTouchedNumber(num)) return false;

            // タッチ後一定の時間が経過してから，再びタッチの検出を有効にするため
            delay_.Disable();

            factor_ = (num == 1) ? factor_*2 : factor_/2;
            if (factor_ > MAX_) factor_ = MAX_;
            if (factor_ < MIN_) factor_ = MIN_;

            zoom_->ActivateAll();
            if (factor_ == MAX_) zoom_->Inactivate(num);
            if (factor_ == MIN_) zoom_->Inactivate(num);

            factor = factor_;

            return true;
        }

    private:
        const int X0_, Y0_, W0_, H0_;
        const uint32_t MAX_;    // 最大値
        const uint32_t MIN_;    // 最小値

        ButtonGroup *zoom_;
        DelayedEnabler delay_;
        int factor_;
    };
}
#endif  // ZOOM_BUTTON_HPP
