//-----------------------------------------------------------------
//  ディジタルフィルタ実験のためのプラットフォーム（標本化周波数：48 kHz）
//      ---- 入出力信号の波形表示付き ----
//
//  一次の IIR フィルタ：  ターミナルソフトから係数変更可能
//
//  使用しているライブラリのリビジョン：
//          mbed                Rev.154
//          BSP_DISCO_F746NG    Rev.9
//
//  2017/11/08, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------------

#include "SAI_InOut.hpp"
#include "LcdPanelFrq.hpp"
#include "TerminalInput.hpp"    // ターミナルとの通信用
#pragma diag_suppress 870       // マルチバイト文字使用の warning 抑制のため

//-----------------------------------------------------------------
// 実行するフィルタに応じて以下のインクルードファイルを変更する
#include "IIR1_Variable.hpp"    // 一次の IIR フィルタ
//-----------------------------------------------------------------

int main()
{
    //-------------------------------------------------------------
    // xxxx_Variable 版の追加箇所
    const string MESSAGE = "0 以上 1 未満の数を入力してください\r\n";
    TermInput comm("\r\nここから a の値を変更できます．\r\n");
    comm.printf(MESSAGE+"? ");
    // xxxx_Variable 版の追加箇所：ここまで
    //-------------------------------------------------------------

    const int FS = I2S_AUDIOFREQ_48K;   // 標本化周波数：48 kHz
    // オーディオ信号出力用
    SaiIO mySai(SaiIO::OUTPUT, 2048, FS);

    // LCD パネル表示用
    LcdPanel myPanel(1.0f/(float)FS);

    //-----------------------------------------------------------------
    // ここでディジタルフィルタのオブジェクト生成や初期化などを行う
    Iir1Variable df(0.9f);
    //-----------------------------------------------------------------
    
    mySai.PlayOut();    // オーディオ信号出力開始

    const float MAX_AMP = 10000.0f;
    string rxBuf = "";
    while (true)        // 無限ループ
    {
        // 出力バッファへの転送が完了したら以下の処理を行う
        if (mySai.IsXferred())
        {
            for (int n=0; n<mySai.GetLength(); n++)
            {
                // 入力信号の生成
                float phi = myPanel.GetPhi();
                float sn = sinf(phi); // 入力信号となる正弦波を発生

                int16_t xn = (int16_t)(MAX_AMP*sn);
                //------------------------------------------------------
                // ディジタルフィルタなどの信号処理の実行
                int16_t yn = df.Execute(xn);
                //------------------------------------------------------
                mySai.Output(xn, yn);       // xn：入力（左チャンネル）
                                            // yn：出力（右チャンネル）
                myPanel.Store(xn, yn, n);   // 表示用として格納
            }

            myPanel.Display();  // 入出力信号の波形表示
        }
        myPanel.Update();   // パネルの状態を読み取り必要なパラメータなどを更新する

        //---------------------------------------------------------
        // xxxx_Variable 版の追加箇所
        // ターミナルとの通信
        float val;
        if (comm.Get(val))  // 入力が完了していれば以下を実行する
        {
            if ((0 <= val) && (val < 1.0f))
                df.SetCoefs(val);
            else
                comm.printf(MESSAGE);
            comm.printf("? ");
        }
        // xxxx_Variable 版の追加箇所：ここまで
        //---------------------------------------------------------
    }
}
