//---------------------------------------------------
//  一次の IIR フィルタ ― 係数可変
//
//  2017/09/24, Copyright (c) 2017 MIKAMI, Naoki
//---------------------------------------------------

#ifndef IIR_1ST_VARIABLE_HPP
#define IIR_1ST_VARIABLE_HPP

#include "mbed.h"

class Iir1Variable
{
public:
    Iir1Variable(float a1)
        : a1_(a1), b0_(1.0f - a1), yn_(0) {}

    // フィルタ処理を実行する
    int16_t Execute(int16_t xn)
    {
        yn_ = a1_*yn_ + b0_*xn;

        return (int16_t)yn_;
    }
    
    void SetCoefs(float a1)
    {
        a1_ = a1;
        b0_ = 1.0f - a1;
    }

private:
    float a1_;  // 係数
    float b0_;  // 係数
    float yn_;
};
#endif  // IIR_1ST_VARIABLE_HPP