//-----------------------------------------------------------
//  ある機能を一定の時間が経過するまでは無効にし，その後有効に
//  するためのクラス
//
//  2017/08/21, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef DELAYED_ENABLER_HPP
#define DELAYED_ENABLER_HPP

#include "mbed.h"

namespace Mikami
{
    class DelayedEnabler
    {
    public:
        DelayedEnabler(float delayTime = 0.3f)
            : DELAY_TIME_(delayTime), enable_(true) {}

        // このメンバ関数の実行直後から指定された時間，IsEnabled() は false を
        // 返し，その後 InEnabled() は true を返す
        void Disable()
        {
            enable_ = false;
            Enabler_.attach(callback(this, &DelayedEnabler::TimeoutIsr),
                            DELAY_TIME_);
        }

        bool IsEnabled() { return enable_; }

    private:
        const float DELAY_TIME_;    // 無効になっている時間

        __IO bool enable_;
        Timeout Enabler_;

        // 有効にする（Timeout 割り込みに対応する ISR）
        void TimeoutIsr() { enable_ = true; }
    };
}
#endif  // DELAYED_ENABLER_HPP
