//-----------------------------------------------------------
//  Class for waveform display
//
//  2017/07/24, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#include "WaveformDisplay.hpp"

namespace Mikami
{
    void WaveformDisplay::Execute(int start, int factor)
    {
        Axis();
        dt_ = factor;
        Draw(xn_, start, LINE_COLOR1_);
        Draw(yn_, start, LINE_COLOR2_);
        lcd_.SetTextColor(BACK_COLOR_);
    }
        
    // Clipping
    uint16_t WaveformDisplay::Clip(int16_t xn)
    {
        int16_t x = xn >> R_SHIFT_;
        if (x >  LIMIT_ ) x =  LIMIT2_;
        if (x < -LIMIT_ ) x = -LIMIT2_ ;
        return Y0_ - x;
    }
    
    void WaveformDisplay::Draw(const Array<int16_t>& xn, int start, uint32_t color)
    {
        lcd_.SetTextColor(color);
        uint16_t x1 = X0_;
        uint16_t y1 = Clip(xn[start]);
//        for (int n=1; n<N_DATA_; n++)
        for (int n=1; n<N_DATA_/dt_; n++)
        {
//            uint16_t x2 = X0_ + n;
            uint16_t x2 = X0_ + n*dt_;
            uint16_t y2 = Clip(xn[start+n]);
            lcd_.DrawLine(x1, y1, x2, y2);

            x1 = x2;
            y1 = y2;
        }
    }

    void WaveformDisplay::Axis()
    {
        lcd_.SetTextColor(BACK_COLOR_);
        lcd_.FillRect(X0_, Y0_-LIMIT2_, N_DATA_, LIMIT2_*2+1);

        lcd_.SetTextColor(AXIS_COLOR_);
        lcd_.DrawLine(X0_-5, Y0_, X0_+N_DATA_+5, Y0_);
    }        
}
