//---------------------------------------------------
// 適応線スペクトル強調器（ALE）： μ可変
//
//  2018/03/20, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------

#ifndef IIR_1ST_VARIABLE_HPP
#define IIR_1ST_VARIABLE_HPP

#include "Array.hpp"

class AleVariable
{
public:
    // コンストラクタ
    AleVariable(int delay, int order, float mu)
        : xm_(delay, 0.0f), xk_(order+1, 0.0f), hk_(order+1, 0.0f),
          delay_(delay), order_(order), mu_(mu) {}

    // ALE を実行する
    int16_t Execute(int16_t xn)
    {
        // FIRフィルタの計算
        float yn = 0.0f;
        for (int k=0; k<=order_; k++) yn = yn + hk_[k]*xk_[k];

        // 係数の更新
        float errMu = (xn - yn)*mu_;    // 誤差信号×μ の計算
        for (int k=0; k<=order_; k++) hk_[k] = hk_[k] + errMu*xk_[k];

        for (int k=order_-1; k>=0; k--) // フィルタ内の信号のシフト
            xk_[k+1] = xk_[k];
        xk_[0] = xm_[delay_-1];         // フィルタの初段に遅延器の最終段の信号を格納
        for (int k=delay_-2; k>=0; k--) // 遅延器内の信号のシフト
            xm_[k+1] = xm_[k];
        xm_[0] = xn;                    // 遅延器の初段に入力信号を格納

        return (int16_t)yn;
    }
    
    // μ の設定
    void SetMu(float mu) { mu_ = mu; }

private:
    Array<float> xm_;   // 相関除去のための遅延器
    Array<float> xk_;   // FIR フィルタの遅延器
    Array<float> hk_;   // FIR フィルタの係数

    int delay_;         // 相関除去のための遅延器数
    int order_;         // FIR フィルタの次数
    float mu_;          // ステップサイズパラメータ
};
#endif  // IIR_1ST_VARIABLE_HPP
