//-----------------------------------------------------------
//  Class for waveform display ---- Header
//
//  2017/07/24, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_WAVEFORM_DISPLAY_HPP
#define F746_WAVEFORM_DISPLAY_HPP

#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "Array.hpp"

namespace Mikami
{
    class WaveformDisplay
    {
    public:
        WaveformDisplay(LCD_DISCO_F746NG &lcd,
                        uint16_t x0, uint16_t y0,
                        const Array<int16_t>& xn,
                        const Array<int16_t>& yn,
                        uint16_t nData,
                        uint16_t rShift,
                        uint32_t axisColor,
                        uint32_t lineColor1,
                        uint32_t lineColor2,
                        uint32_t backColor)
            : X0_(x0), Y0_(y0), xn_(xn), yn_(yn),
              N_DATA_(nData),
              R_SHIFT_(rShift),
              AXIS_COLOR_(axisColor),
              LINE_COLOR1_(lineColor1), LINE_COLOR2_(lineColor2),
              BACK_COLOR_(backColor),
              lcd_(lcd), dt_(1) { Axis(); }
        
        void Execute(int start, int factor);
        
    private:
        const uint16_t X0_, Y0_;
        const Array<int16_t>& xn_;
        const Array<int16_t>& yn_;
        const int N_DATA_;
        const uint16_t R_SHIFT_;
        const uint32_t AXIS_COLOR_;
        const uint32_t LINE_COLOR1_;
        const uint32_t LINE_COLOR2_;
        const uint32_t BACK_COLOR_;
        static const int LIMIT_ = 64;
        static const int LIMIT2_ = LIMIT_ + 1;

        LCD_DISCO_F746NG &lcd_;

        int dt_;

        uint16_t Clip(int16_t xn);  // Clipping
        void Draw(const Array<int16_t>& xn, int start, uint32_t color);
        void Axis();

        // disallow copy constructor and assignment operator
        WaveformDisplay(const WaveformDisplay& );
        WaveformDisplay& operator=(const WaveformDisplay& );
    };
}
#endif  // F746_WAVEFORM_DISPLAY_HPP
