//-----------------------------------------------------------
//  ターミナルからパラメータを入力するためのクラス
//
//  2017/10/09, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef TERMINAL_INPUT_HPP
#define TERMINAL_INPUT_HPP

#include "mbed.h"
#pragma diag_suppress 870   // マルチバイト文字使用の warning 抑制のため

namespace Mikami
{
    class TermInput
    {
    public:
        // コンストラクタ
        //      str: オブジェクトを生成する際に表示される文字列
        TermInput(const string str = "") : pc_(USBTX, USBRX), rxBuf_("")
        {
            if (str != "") pc_.printf("%s", str.c_str());
        }
    
        // ターミナルから入力された float 型の数値を取得する
        //      val: ターミナルから入力された数値
        //      戻り値: 入力が正常に完了した場合に true
        //             それ以外は false
        bool Get(float &val)
        {
            // ターミナルからの送信がなければ直ちに false を返す
            if (!pc_.readable()) return false;
            
            // ターミナルからのデータを受け取った場合の処理
            bool rtn = false;
            char ch = pc_.getc();   // 受信バッファから１文字取得
            pc_.putc(ch);           // 同じ文字をターミナルへ送信
            if (ch == '\r')         // "Enter" を受信した場合は
            {
                pc_.putc('\n');     // "LF" も送信する

                char *endptr;
                val = strtof(rxBuf_.c_str(), &endptr);
                if (*endptr == NULL)
                    rtn = true;
                else
                    pc_.printf("不正な入力です．\r\n? ");
                rxBuf_ = "";
            }
            else
                rxBuf_ += ch;
                
            return rtn;
        }

        // ターミナルに出力する
        void printf(const string str) { pc_.printf("%s", str.c_str()); }

    private:
        Serial pc_;
        string rxBuf_;
    };
}
#endif  // TERMINAL_INPUT_HPP
