//----------------------------------------------------------
//  Simultanuous AD Conversion by interrupt using
//  ADC1 and ADC3 on STM32F746 ---- Header
//
//  STM32F746 の ADC1, ADC3 を使って同時に AD 変換を開始し，
//  割り込みによりアナログ信号を入力するクラス（ヘッダ）
//      AdcDual クラスの派生クラス
//
//  2017/08/16, Copyright (c) 2017 MIKAMI, Naoki
//----------------------------------------------------------

#ifndef F746_ADC_DUAL_INTERRUPT_HPP
#define F746_ADC_DUAL_INTERRUPT_HPP

#include "F746_ADC.hpp"

namespace Mikami
{
    class AdcDual_Intr : public AdcDual
    {
    public:
        explicit AdcDual_Intr(int frequency) : AdcDual(frequency)
        {   ADC1->CR1 |= ADC_CR1_EOCIE; }
        
        virtual ~AdcDual_Intr() {}

        // -1.0f <= ad1, ad2 <= 1.0f
        virtual void Read(float &ad1, float &ad2)
        {
            ad1 = ToFloat(ADC1->DR);
            ad2 = ToFloat(ADC3->DR);
        }

        // 0 <= ad1, ad2 <= 4095
        virtual void Read(uint16_t &ad1, uint16_t &ad2)
        {
            ad1 = ADC1->DR;
            ad2 = ADC3->DR;
        }

        // Set interrupt vector
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
        }
        
        void EnableAdcIntr()
        {   
            NVIC_EnableIRQ(ADC_IRQn);   // See "core_cm7.h"
        }

        void DisableAdcIntr()
        {
            NVIC_DisableIRQ(ADC_IRQn);  // See "core_cm7.h"
        }
        
    private:
        // for inhibition of copy constructor
        AdcDual_Intr(const AdcDual_Intr&);
        // for inhibition of substitute operator
        AdcDual_Intr& operator=(const AdcDual_Intr&);     
    };
}
#endif  // F746_ADC_DUAL_INTERRUPT_HPP

