//-----------------------------------------------------------
//  ディジタルフィルタ実験のためのプラットフォームの
//  LCD パネル表示と操作で使う
//
//  2017/10/07, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef PANEL_MANIPULATOR_HPP
#define PANEL_MANIPULATOR_HPP

#include "F746_GUI.hpp"
#include "NumericUpDown.hpp"
#include "Zoom.hpp"
#include "WaveformDisplay.hpp"
#include "Trigger.hpp"

namespace Mikami
{
    class LcdPanel
    {
    public:
        LcdPanel() : lcd_(GuiBase::GetLcd()),
                     xnD_(N_DISP_BUF_), ynD_(N_DISP_BUF_), factor_(1)
        {
            Label title(240, 10, "Digital Filter LAB using internal ADC",
                        Label::CENTER, Font16);

            const uint16_t Y0 = 170;
            // 凡例
            lcd_.SetTextColor(LINE_COLOR1_);
            lcd_.DrawHLine(360, Y0+6, 50);
            Label label1(420, Y0, "Input");
            lcd_.SetTextColor(LINE_COLOR2_);
            lcd_.DrawHLine(360, Y0+26, 50);
            Label label2(420, Y0+20, "Output");

            waveDisp_ = new WaveformDisplay(lcd_, 30, 90, xnD_, ynD_, 400, 8,
                                            AXIS_COLOR_,
                                            LINE_COLOR1_, LINE_COLOR2_,
                                            BACK_COLOR_);

            // 時間軸の拡大率は 8 倍まで
            zmButton_ = new ZoomButton(240, Y0, 40, 30, 8);
        }

        // ズームイン／アウト･ボタンの処理
        void Update() { zmButton_->Touched(factor_); }

        // 入出力信号のデータを表示用バッファへ格納
        void Store(int16_t xn, int16_t yn, int n)
        {
            if (n >= N_DISP_BUF_) return;

            xnD_[n] = xn;
            ynD_[n] = yn;
        }
        
        // 入出力信号の波形の表示
        void Display() { waveDisp_->Execute(Trigger(xnD_, 1), factor_); }

    private:
        static const uint32_t BACK_COLOR_ = GuiBase::ENUM_BACK;
        static const uint32_t AXIS_COLOR_ = 0xFFCCFFFF;
        static const uint32_t LINE_COLOR1_ = LCD_COLOR_CYAN;
        static const uint32_t LINE_COLOR2_ = LCD_COLOR_MAGENTA;
        static const int N_DISP_BUF_ = 1000;    // 波形表示用のバッファのサイズ

        LCD_DISCO_F746NG &lcd_;
        WaveformDisplay *waveDisp_;
        ZoomButton *zmButton_;  // 波形表示：ズームイン/アウト用

        Array<int16_t> xnD_;    // 波形表示で使うバッファ（入力信号用）
        Array<int16_t> ynD_;    // 波形表示で使うバッファ（出力信号用）
        int factor_;            // 波形表示の際の標本化間隔に対応するピクセル数
    };
}
#endif  // PANEL_MANIPULATOR_HPP
