//---------------------------------------------------
//  定数乗算器
//
//  2018/03/20, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------

#ifndef CONST_MULTIPLY_HPP
#define CONST_MULTIPLY_HPP

#include "mbed.h"

class Multiplier
{
public:
    // コンストラクタ
    Multiplier(float factor) : C_(factor) {}

    // 定数を乗算する処理の実行，戻り値は int16_t 型とすること
    int16_t Execute(int16_t xn)
    {
        float yn = C_*xn;
        return (int16_t)yn;
    }
private:
    const float C_;
};
#endif  // CONST_MULTIPLY_HPP
