//--------------------------------------------------------------
// 割り込みを使わずに AD DA を行う場合の雛形, 入力切替
//      Analog line Input : A0 (channel 1)
//      Analog mic. Input : A1 (channel 2)
//      Analog Output: MCP4922 using SPI
//      Switch : D2
// 2014/12/19, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922
#include "ACM1602NI.hpp"        // for LCD display

using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
ADC_Base adc_(A0, FS_, A1);     // for AD
DAC_MCP4922 myDac_;             // for DA

DigitalIn sw_(D2, PullDown);

int main()
{
    myDac_.ScfClockTim3(420000);    // cutoff frequency: 4.2 kHz
    int swBefore = 0;

    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------
        // Put signal processing program here
        //-----------------------------------------------
        myDac_.Write(xn);           // Write to DAC
        
        int swNow = sw_.read();
        if (swNow != swBefore)
        {
            if (swNow == 0) adc_.Select1stChannel(); // line input
            else            adc_.Select2ndChannel(); // mic. input
            swBefore = swNow;
        }
    }
}
