//--------------------------------------------------------------
// 割り込みを使わずに AD DA を行う場合の雛形
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2015/02/03, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922
#include "ACM1602NI.hpp"        // for LCD display

using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
ADC_Base adc_(A0, FS_);         // for AD
DAC_MCP4922 myDac_;             // for DA

int main()
{
    myDac_.ScfClockTim3(420000);    // cutoff frequency: 4.2 kHz

    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------
        // Put signal processing program here
        //-----------------------------------------------
        myDac_.Write(xn);           // Write to DAC
    }
}
