//--------------------------------------------------------------
// 割り込みを使って AD DA を行う場合の雛形2（入力：2 チャンネル）
//      Analog Input : A0, A3 (A1: not used)
//              A3 is used to cotrol volume of output signal
//      Analog Output: MCP4922 using SPI
//      A2: used for control volume of output
// 2014/12/19, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_Interrupt.hpp"    // for ADC using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
ADC_Intr adc_(A0, FS_, A1, A2); // for AD
DAC_MCP4922 myDac_;             // for DA

uint16_t a2_ = 0;
uint16_t a21_ = 0;
float vol_ = 1.0f;

// Interrupt service routine for ADC
void AdcIsr()
{   
    float xn = adc_.Read();     // Read from A0

    adc_.Select3rdChannel();    // Enable A2   
    adc_.SoftStart();           // ADC start for A2 input
    
    float yn = vol_*xn; // Volume control by VR
    myDac_.Write(yn);   // to DAC

    // Read value which controls volume
    a2_ = adc_.ReadWait_u16();

    adc_.Select1stChannel();        // Enable A0
    adc_.ClearPending_EnableIRQ();  // Clear pending interrupt
}

int main()
{
    myDac_.ScfClockTim3(420000);    // cutoff frequency: 4.2 kHz
    adc_.SetIntrVec(AdcIsr);    // Assign ISR for ADC interrupt

    while (true)
    {
        if (abs(a2_ - a21_) > 10)
        {
            vol_ = ((float)a2_)/4095.0f;
            a21_ = a2_;
        }
        wait(0.1f);
    }
}
