//--------------------------------------------------------------
// 割り込みを使って AD DA を行う場合の雛形1（入力：1 チャンネル）
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/12/19, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Interrupt.hpp"    // for ADC using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
ADC_Intr adc_(A0, FS_);         // for AD
DAC_MCP4922 myDac_;             // for DA

// Interrupt service routine for ADC
void AdcIsr()
{   
    float xn = adc_.Read(); // Read from A0
    myDac_.Write(xn);       // to DAC
}

int main()
{
    myDac_.ScfClockTim3(420000);    // cutoff frequency: 4.2 kHz
    adc_.SetIntrVec(AdcIsr);        // Assign ISR for ADC interrupt

    while (true) {}
}
