//------------------------------------------------------------
// Test program for LCD ACM1602NI using I2C interface
//      Pullup resistors for SDA and SCL: 4.7 kΩ
//      MIKAMI, Naoki (c) 2014/08/28
//------------------------------------------------------------

#include "mbed.h"
#include "ACM1602NI.hpp"
using namespace Mikami;

//Acm1602Ni lcd_;                               // Default, OK
//Acm1602Ni lcd_(D14, D15);                     // OK
Acm1602Ni lcd_(D14, D15, 200000);             // OK
//Acm1602Ni lcd_(D14, D15, 200000, true, true); // OK
//Acm1602Ni lcd_(PB_3, PB_10);                  // OK
//Acm1602Ni lcd_(PC_9, PA_8);                   // OK
//Acm1602Ni lcd_(PB_4, PA_8);                   // OK 

Ticker timer_;

// Display 0, 1, 2, .....
void TimerIsr()
{
    static int k = 0;
    char str[20];
    sprintf(str, "%d", k++);
    lcd_.WriteString(str, 0, 1);
}

int main()
{
    lcd_.Clear();
    lcd_.WriteString("Hello World!");

    timer_.attach(&TimerIsr, 1);

    while (true) {}
}
