#include "mbed.h"

#include "main.h"




Serial command(USBTX, USBRX);



int main() {
    init_servo();
    init_serial();

    debug_m("inicio \n");
    uint32_t read_cc;
    while(1)
    {
        read_cc=read_command();
        switch (read_cc) {
            case  0x01: moving(); break;
         case  0x02: moving(); break;
         case  0x03: moving(); break;
            default: debug_m("error de comando.  \n");break ;      
        }
    }
}



uint32_t read_command()
{
   // retorna los byte recibidos concatenados en un entero, 
   

    
    char intc=command.getc();
    
    while(intc != '<' )
        intc=command.getc();
    return command.getc();
}


void init_serial()
{
    command.baud(9600);    
}


void moving(){
    debug_m("se inicia el comado mover..\n");    
    
    char nmotor=command.getc();
    char grados=command.getc();
    debug_m("SE MUEVE EL MOTOR %d, EN %d GRADOS ..\n", nmotor,grados );    
    char endc=command.getc();
    mover_ser(nmotor,grados); 
    
    debug_m("fin del comado MOVER ..\n");    
    
}

void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}