#include "mbed.h"
#define MAXPOS 180      // en milimetros
#define SS_TIME 100     // en microsegundos
#define POSDRAW 10      

PwmOut myServoX(PB_3);
PwmOut myServoY(PB_4);
PwmOut myServoZ(PB_5);


int coord2us(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/180);// u6
    return 750;

}

void draw()
{
myServoZ.pulsewidth_us(POSDRAW);
wait(1);
}
void nodraw()
{
myServoZ.pulsewidth_us(MAXPOS);
wait(1);
}
void vertex2d(float x, float y){

    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    
    myServoX.pulsewidth_us(pulseX);
    myServoY.pulsewidth_us(pulseY);
    wait_ms(SS_TIME);

}



int main() {
     // configuracion de  periodo
    myServoX.period_ms(20);
    myServoY.period_ms(20);
    int posx=0;
    int posy=0;
    draw();
    while(1)
    {
        wait(2);
        vertex2d(posx,posy);
        posx+=90;
        posy+=90;
        if (posx>180){
            posx=0;
            nodraw();
        }
        if (posy>180){
            posy=0;
            nodraw();
        }
        
   }

}

