// The MIT License (MIT)
//
// Copyright (c) 2015 THINGER LTD
// Author: alvarolb@gmail.com (Alvaro Luis Bustamante)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef THINGER_MBED_ETHERNET_H
#define THINGER_MBED_ETHERNET_H

#include "ThingerMBedClient.h"

//#define _DEBUG_

#ifndef _DHCP_  // Should be defined your network information.
    #define DEV_IP_ADDRESS "192.168.0.100"
    #define DEV_GW_ADDRESS "192.168.0.1"
    #define DEV_SN_ADDRESS "255.255.255.0"
#endif    


class ThingerEthernet : public ThingerClient {

public:
    ThingerEthernet(const char* user, const char* device, const char* device_credential) :
            ThingerClient(client_, user, device, device_credential), connected_(false)
    {}

    ~ThingerEthernet(){

    }

protected:

    virtual bool network_connected(){
        return connected_;
    }

    virtual bool connect_network(){
        if(connected_) return true;
        uint8_t mac[6] = { 0x1D, 0xdc, 0x08, 0x00, 0x62, 0x11 };
        unsigned long ethernet_timeout = millis();

#ifdef _DHCP_        
    #ifdef _DEBUG_
        printf("[NETWORK] Getting DHCP IP Address...\r\n");
    #endif
        ((EthernetInterface*)WIZnet_Chip::getInstance()).init(mac);
#else
        ((EthernetInterface*)WIZnet_Chip::getInstance())->init(mac,DEV_IP_ADDRESS,DEV_SN_ADDRESS,DEV_GW_ADDRESS);
#endif
                  
        ((EthernetInterface*)WIZnet_Chip::getInstance())->ethernet_link();
        delay(3000);
    #ifdef _DEBUG_
        #ifdef _DHCP_
            printf("[NETWORK] Waiting for IP...\r\n");
        #endif
    #endif

        connected_ = true;    
        if(((EthernetInterface*)WIZnet_Chip::getInstance())->connect() > 0) connected_ = false;

#ifdef _DEBUG_
        printf("[NETWORK] Got Ip Address: %s\r\n",((EthernetInterface*)WIZnet_Chip::getInstance())->getIPAddress());
#endif
        delay(1000);
        return connected_;
    }

private:
    bool connected_;
    TCPSocketConnectionArdu  client_;
};

#endif