/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "TCPSocketConnectionArdu.h"

 
ssize_t TCPSocketConnectionArdu::write(uint8_t b) { 
    return write((char*)&b,1); 
}

/** Send data to the remote host.
\param data The buffer to send to the host.
\param length The length of the buffer to send.
\return the number of written bytes on success (>=0) or -1 on failure
 */
ssize_t TCPSocketConnectionArdu::write(const void *buf, size_t size)  {
    return send((char*)buf, size);
}

int TCPSocketConnectionArdu::available(){
    return eth->wait_readable(_sock_fd, 1500, 0);
}

int TCPSocketConnectionArdu::read(){
    uint8_t b;
    if(receive((char*)b, 1) > 0) return b;
    return -1;
}

ssize_t TCPSocketConnectionArdu::read(void *buf, size_t size) {
    return receive((char*)buf, size);
}

int TCPSocketConnectionArdu::readBytes(uint8_t* buf, size_t size) { return read(buf,size);}

int TCPSocketConnectionArdu::peek(){
    if(available()==0) return -1;
    return available();
}

void TCPSocketConnectionArdu::flush() {
    while(available()>0) read();
}

void TCPSocketConnectionArdu::stop(){
  if (_sock_fd == -1)
    return;

  // attempt to close the connection gracefully (send a FIN to other side)
  TCPSocketConnection::close();
  _sock_fd = -1;
    
}

/** Check if the socket is connected
\return true if connected, false otherwise.
*/
uint8_t TCPSocketConnectionArdu::connected(){
    return is_connected();
}

TCPSocketConnectionArdu::operator bool() { return _sock_fd != -1;}

