/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef TCPSOCKET_ARDU_H
#define TCPSOCKET_ARUD_H

#include "EthernetInterface.h"
/**
TCP socket connection for compatible Arduino
*/
class TCPSocketConnectionArdu : public TCPSocketConnection {
    
public:
    /** TCP socket connection
    */
    TCPSocketConnectionArdu() {};
    virtual ~TCPSocketConnectionArdu() { TCPSocketConnection::close(); };
     
    ssize_t write(uint8_t);

    /** Send data to the remote host.
    \param data The buffer to send to the host.
    \param length The length of the buffer to send.
    \return the number of written bytes on success (>=0) or -1 on failure
     */
    virtual ssize_t write(const void *buf, size_t size);
    virtual int available();
    ssize_t read();    
    virtual ssize_t read(void *buf, size_t size);    
    virtual ssize_t readBytes(uint8_t* buf, size_t size);
    virtual ssize_t peek();
    virtual void flush();
    virtual void stop();

    /** Check if the socket is connected
    \return true if connected, false otherwise.
    */
    virtual uint8_t connected();
    virtual operator bool(); 
       
    friend class TCPSocketServer;
    
};

#endif
