#include "mbed.h"
#include "EthernetInterface.h"
#include "DHT.h"

#include "TCPSocketConnectionArdu.h"
#include "ThingerMBedEthernet.h"
#include "ThingerMBedClient.h"


/* ThingerIO Define */
#define USERNAME "MidnightCow"
#define DEVICE_ID "WIZwiki_W7500_mbed_01"
#define DEVICE_CREDENTIAL "Your Access Key"

/* YUROBOT SHILED1 PIN Define*/
#define myLED1      D13
#define myLED2      D12

#define myRLED      D9
#define myGLED      D10
#define myBLED      D11

#define myBUZZ      D5

#define myTEMPHUMM  D4

#define myLIGHT     A1

//using namespace std;
DigitalOut myled1(myLED1);
DigitalOut myled2(myLED2);

DigitalOut myrled(myRLED);
DigitalOut mygled(myGLED);
DigitalOut mybled(myBLED);
DigitalOut myBuzz(myBUZZ);

AnalogIn   mylight(myLIGHT);

DHT myTempHumm(myTEMPHUMM, DHT11);



void my_led1(pson& in)
{
    myled1 = (in) ? 1 : 0;
}

void my_led2(pson& in)
{
    myled2 = (in) ? 1 : 0;
}

void my_TempHumm(pson& out)
{
    if(myTempHumm.readData() == 0)
    {
        out["Cecelcius"] = myTempHumm.ReadTemperature(CELCIUS);
        out["Humidity"]  = myTempHumm.ReadHumidity();        
    }
    else
    {
        out["Cecelcius"] = 65535;
        out["Humidity"]  = 65535;
    }
}

/*
void my_rgbled(pson& in)
{
    myrled = (in["Red"])   ?  1 : 0;
    mygled = (in["Green"]) ?  1 : 0;
    mybled = (in["Blue"])  ?  1 : 0;    
}
*/


int main() {

    EthernetInterface eth;

    ThingerEthernet thing(USERNAME, DEVICE_ID, DEVICE_CREDENTIAL);

    myled1 = 1;
    myled2 = 1;

    // resource input example (i.e. turning on/off a light, a relay, configuring a parameter, etc)
    thing["myled1"] << my_led1;
    thing["myled2"] << my_led2;
    thing["mySensor"] >> my_TempHumm;
    //thing["myRGB"] << my_rgbled;
    
    while(1)
    {
        thing.handle();
    }
}
