#ifndef FTP_CLIENT_H
#define FTP_CLIENT_H
#include "mbed.h"
#include "SDFileSystem.h"
#define MAX_SS              512
/** FTPClient class.
 *  Used file transfer with FTPServer like ALFTP(http://software.altools.co.kr/ko-kr/closed.html)
 *  This test was completed in ALFTP
 */
class FTPClient{
public:
    /** Create FTPClient instance */
    FTPClient(PinName mosi, PinName miso, PinName sclk, PinName ssel, const char* root);
    FTPClient(const char* root);
    ~FTPClient();
    
    /** Connect to FTPServer
     *
     * @param FTPServer IP, FTPServer PORT, FTPServer login ID, FTPServer login PASS
     * @returns
     *   1 on success,
     *   0 on open error
     */
    bool open(char* ip, int port, char* id, char* pass);
    
    /** Get file from FTPServer
     *
     * @param filename 
     * @returns
     *   1 on success,
     *   0 on getfile error
     */
    bool getfile(char* filename);
    
    /** Put file to FTPServer
     *
     * @param FTPServer file name 
     * @returns
     *   1 on success,
     *   0 on putfile error
     */
    bool putfile(char* filename);
    
    /** View FTPServer directory
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on dir error
     */
    bool dir(char* liststr);
    
    /** View FTPServer directory
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on ls error
     */
    bool ls(char* liststr);
    
    /** Delete FTPServer file
     *
     * @param FTPServer file name
     * @returns
     *   1 on success,
     *   0 on delete error
     */
    bool fdelete(char* filename);
    
    /** Make FTPServer directory
     *
     * @param FTPServer directory name
     * @returns
     *   1 on success,
     *   0 on mkdir error
     */
    bool mkdir(char* dirname);
    
    /** Change current FTPServer directory
     *
     * @param FTPServer directory name
     * @returns
     *   1 on success,
     *   0 on mkdir error
     */
    bool cd(char* dirname);
    
    /** Disconnect from FTPServer
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on Disconnect error
     */
    bool quit();
      
private:
    TCPSocketConnection FTPClientControlSock;
    TCPSocketConnection FTPClientDataSock;
    
    bool blogin;
    
    char ftpServer_data_ip_addr_str[20];
    int remote_port;
    
    char ftpbuf[MAX_SS];
    

    SDFileSystem* _SDFileSystem;
    
    int pportc(char * arg);
    
    char root[20];
};
#endif