#include "mbed.h"
#include "EthernetInterface.h"
#include "FTPClient.h"

//#define DEBUG

FTPClient::FTPClient(PinName mosi, PinName miso, PinName sclk, PinName ssel, const char* root) {
    _SDFileSystem = new SDFileSystem(mosi, miso, sclk, ssel, root);
    blogin = false;
    strcpy(this->root,root);
}

FTPClient::FTPClient(const char* root)
{
    _SDFileSystem = NULL;
    blogin = false;
    strcpy(this->root,root);
}

FTPClient::~FTPClient()
{
    if(_SDFileSystem == NULL) delete _SDFileSystem;
}

bool FTPClient::open(char* ip, int port, char* id, char* pass){
    
    int size;
    blogin = false;

    if (FTPClientControlSock.connect(ip, port) < 0) {
    #ifdef DEBUG
        printf("Unable to connect to (%s) on port (%d)\r\n", ip, port);
    #endif
        wait(1);
        return false;
    }
    
    while(!blogin){
        size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", ftpbuf);
        #endif
            if (!strncmp(ftpbuf, "220", 3)){
                printf("%s\r\n", ftpbuf);
                sprintf(ftpbuf, "user %s\r\n", id);             
                FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
            }
            else if (!strncmp(ftpbuf, "331", 3)){
                sprintf(ftpbuf, "pass %s\r\n", pass);             
                FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
            }
            else if (!strncmp(ftpbuf, "230", 3)){
                blogin = true;
            }
            else{
                break;
            }
        }  
    }
    return blogin;
}

bool FTPClient::getfile(char* filename){
    FILE* fp;
    int size;

    if(blogin){
        printf("%08X\r\n",ftpbuf);
        sprintf(ftpbuf, "pasv\r\n");             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        while(1){
            size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", ftpbuf);
            #endif
                if (!strncmp(ftpbuf, "150", 3)){
                    sprintf(ftpbuf,"%s/%s\0",root,filename);
                #ifdef DEBUG
                    printf("myfilename : %s\r\n", ftpbuf); 
                #endif
                    fp = fopen(ftpbuf, "w");
                    while(1){
                        size = FTPClientDataSock.receive(ftpbuf, sizeof(ftpbuf));
                    #ifdef DEBUG
                        printf("remain_datasize : %d\r\n", size);
                    #endif
                        if(size>0){
                            fwrite(ftpbuf,size,sizeof(char),fp);
                        #ifdef DEBUG
                            printf("#");
                        #endif
                        }
                        if(size < 0 || size < MAX_SS) 
                        {
                            fclose(fp);
                            FTPClientDataSock.close();
                            break;
                        }
                    }
                }
                else if (!strncmp(ftpbuf, "227", 3)){
                    pportc(ftpbuf); 
                    
                #if 1
                    while (FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif
                    
                #if 0
                    do{
                        FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock.is_connected());    
                #endif
                    sprintf(ftpbuf, "retr %s\r\n", filename);             
                    FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));  
                }
                else if(!strncmp(ftpbuf,"226",3)) break;
            }  
        }
        return true;
    }
    return false;
}

bool FTPClient::putfile(char* filename){
    FILE* fp;
    int size;
    long int remain_filesize;
    long int send_byte;
    
    if(blogin){
        
        sprintf(ftpbuf, "pasv\r\n");             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        while(1){
            size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", ftpbuf);
            #endif
                if (!strncmp(ftpbuf, "150", 3)){
                    sprintf(ftpbuf,"%s/%s",root,filename);
                    fp = fopen(ftpbuf, "r"); 
                    fseek(fp, 0, SEEK_END);            // seek to end of file
                    remain_filesize = ftell(fp);       // get current file pointer
                    fseek(fp, 0, SEEK_SET);            // seek back to beginning of file  
                    do{
                        if(remain_filesize > MAX_SS)
                            send_byte = MAX_SS;
                        else
                            send_byte = remain_filesize;
                        fread (ftpbuf, 1, send_byte, fp);
                        FTPClientDataSock.send(ftpbuf, send_byte);
                        remain_filesize -= send_byte;
                    #ifdef DEBUG
                        printf("#");
                    #endif
                    }while(remain_filesize!=0);
                    fclose(fp); 
                    FTPClientDataSock.close();
                    break;
                }
                else if (!strncmp(ftpbuf, "227", 3)){
                    pportc(ftpbuf); 
                #if 0
                    do{
                        FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock.is_connected());  
                #endif
                    
                #if 1
                    while (FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif  
                    sprintf(ftpbuf, "stor %s\r\n", filename);             
                    FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));  
                }
                else if(!strncmp(ftpbuf,"226",3)) break;
            }  
        }
        return true;
    }
    return false;
}

bool FTPClient::dir(char* liststr){
    int size;
    if(blogin){
    
        sprintf(ftpbuf, "pasv\r\n");             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        while(1){
            size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", ftpbuf);
            #endif
                if (!strncmp(ftpbuf, "150", 3)){
                    while(1){
                        size = FTPClientDataSock.receive(ftpbuf, sizeof(ftpbuf));
                        if(size>0){
                            ftpbuf[size] = '\0';
                            strcpy(liststr,ftpbuf);
                            printf("%s", ftpbuf);
                        }
                        else{
                            FTPClientDataSock.close();
                            break;
                        }
                    }
                }
                else if (!strncmp(ftpbuf, "227", 3)){
                    pportc(ftpbuf); 
                #if 0
                    do{
                        FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock.is_connected());   
                #endif
                #if 1
                    while (FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif   
                    sprintf(ftpbuf, "list\r\n");             
                    FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));  
                }
                else if(!strncmp(ftpbuf, "226",3)) break;
            }  
        }
        return true;
    }
    *liststr = 0;
    return false;
}

bool FTPClient::ls(char* liststr){
    
    int size ;
    if(blogin){
    
        sprintf(ftpbuf, "pasv\r\n");             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        while(1){
            size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", ftpbuf);
            #endif
                if (!strncmp(ftpbuf, "150", 3)){
                    while(1){
                        size = FTPClientDataSock.receive(ftpbuf, sizeof(ftpbuf));
                        if(size>0){
                            ftpbuf[size] = '\0';
                            strcpy(liststr,ftpbuf);
                        #ifdef DEBUG
                            printf("%s", ftpbuf);
                        #endif
                        }
                        else{
                            FTPClientDataSock.close();
                            break;
                        }
                    }  
                }
                else if (!strncmp(ftpbuf, "227", 3)){
                    pportc(ftpbuf); 
                #if 0
                    do{
                        FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock.is_connected());   
                #endif
                #if 1
                    while (FTPClientDataSock.connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif   
                    sprintf(ftpbuf, "nlst\r\n");             
                    FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));  
                }
                else if(!strncmp(ftpbuf,"226",3)) break;
            }  
        }
        return true;
    }
    *liststr = 0;
    return false;
}

bool FTPClient::fdelete(char* filename){
    int size;
    if(blogin){
    
        sprintf(ftpbuf, "dele %s\r\n", filename);             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", ftpbuf);
        #endif
            if (!strncmp(ftpbuf, "250", 3))  return true;
        }
    }
    return false;
}

bool FTPClient::mkdir(char* dirname){
    
    int size;
    if(blogin){
    
        sprintf(ftpbuf, "xmkd %s\r\n", dirname);             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", ftpbuf);
        #endif
            if (!strncmp(ftpbuf, "257", 3)) return true;
        }
    }
    return false;
}

bool FTPClient::cd(char* dirname){
    int size;
    
    if(blogin){
    
        sprintf(ftpbuf, "cwd %s\r\n", dirname);             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", ftpbuf);
        #endif
            if (!strncmp(ftpbuf, "250", 3)) return true;
        }
    }
    return false;
}

bool FTPClient::quit(){
    int size;
    if(blogin){
    
        sprintf(ftpbuf, "quit \r\n");             
        FTPClientControlSock.send(ftpbuf, strlen(ftpbuf));
        
        size = FTPClientControlSock.receive(ftpbuf, sizeof(ftpbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", ftpbuf);
        #endif
            if (!strncmp(ftpbuf, "250", 3)){
                printf("%s\r\n", ftpbuf);
                FTPClientControlSock.close();
                blogin = false;
                return true;
            }
        }  
    }
    blogin = false;
    return false;
}

int FTPClient::pportc(char * arg)
{
    uint8_t ip[4];
    char* tok=0;
    char* lasts = 0;
    int i;
   
    tok = strchr(arg, '(') + 1  ;
    for (i = 0; i < 4; i++)
    {
        tok = strtok_r(tok,",", &lasts);
        ip[i] = (uint8_t)atoi(tok);
        tok = lasts;
        if (!tok){
        #ifndef DEBUG
            printf("bad pport : %s\r\n", arg);
        #endif
            return -1;
        }
    }
    remote_port = 0;
    for (i = 0; i < 2; i++){
        tok = strtok_r(tok,",)",&lasts);
        remote_port <<= 8;
        remote_port += atoi(tok);
        tok = lasts;
        if (!tok){
        #ifdef DEBUG
            printf("bad pport : %s\r\n", arg);
        #endif
            return -1;
        }
    }
    sprintf(ftpServer_data_ip_addr_str, "%d.%d.%d.%d", ip[0],ip[1],ip[2],ip[3]);
    return 0; 
}




